% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

function rz = zresult(N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,timeD)

nz = 40; 
ns = 12;
% zero out the data space
zresult = zeros(100,6); 

% start calculating result
for i=1:nz
    z_D = i/nz;
    tval = timeD;
    k=i;
    zresult(k,1) = k;
    zresult(k,2) = z_D;
    zresult(k,3) = Stehfest_inv_Lap(@F_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns); 
    zresult(k,4) = Stehfest_inv_Lap(@F_2,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns); 
    zresult(k,5) = Stehfest_inv_Lap(@FS_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns);
    zresult(k,6) = Stehfest_inv_Lap(@FG_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns);
end

rz = zresult; 
