% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

function rt = result(N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,z_Dsand,timeD)

ns = 12; 
ncycles = 5;
ndiv = 10;

% zero out the data space
result = zeros(ncycles*(ndiv),6); 

% start calculating result
for i=0:(ncycles-1)
    for j=0:(ndiv-1)
        tval = timeD(j+1)*10^(i);
        k=i*(ndiv)+j+1; 
        result(k,1) = k; 
        result(k,2) = tval;
        result(k,3) = Stehfest_inv_Lap(@F_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns); 
        result(k,4) = Stehfest_inv_Lap(@F_2,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_D,ns); 
        result(k,5) = Stehfest_inv_Lap(@FS_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_D,z_Dsand,ns); 
        result(k,6) = Stehfest_inv_Lap(@FG_1,tval,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db,r_Db,z_Dsand,ns); 
    end
end

rt = result; 
