% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function correspons to T_D1(z,s); Eq.(A.16)

function rt = F_1(s, N_s, N_g, N_12, H_g, H_f, kappa, A_D1, A_D2, r_Db, ~, z_D)

rt = C_1(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db)*exp(a1(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db)*z_D)+C_2(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db)*exp(a2(s,N_s,N_g,N_12,H_g,H_f,kappa,A_D1,A_D2,r_Db)*z_D); 