% function used to calculate the analytical solution
% of temperature distribution in an around Borehole 
% Heat Exchangers (BHE) proposed by Beier2014 
%
% Richard A. Beier (2014) Transient heat transfer in a 
% CXA borehole heat exchanger, 
% Geothermics 51: 470-482. 
% 
%
% Author: Chaofan Chen
% Email:  cchaofan1311(at)gmail(dot)com

% This function is according to Eq. (B.12b)
function rt = C0(s, N_s, N_g, H_g, kappa, r_Db)

rt = 1.0 - 1.0/(1.0-kappa*N_s/N_g*sqrt(H_g*s/kappa)*(I_1(sqrt(H_g*s/kappa))-B2B1(s,H_g,kappa,r_Db)*K_1(sqrt(H_g*s/kappa)))/(I_0(sqrt(H_g*s/kappa))+B2B1(s,H_g,kappa,r_Db)*K_0(sqrt(H_g*s/kappa))));